/* basic-N1 */
(function() {

  $(function() {

    $(".basic-N1[id=\'jWMdo3E69W\']").each(function() {

      const $block = $(this);

      let isMobileMenuInitialized = false;

      let isDesktopMenuInitialized = false;

      // 모바일 메뉴 초기화

      function initMobileMenu() {

        if (isMobileMenuInitialized) return;

        const $btnMomenu = $block.find(".btn-momenu");

        $btnMomenu.off("click").on("click", function() {

          if ($block.hasClass("block-active")) {

            $block.removeClass("block-active");

          } else {

            $block.addClass("block-active");

          }

          $block.find(".header-gnbitem").removeClass("item-active");

          $block.find(".header-sublist").removeAttr("style");

        });

        // header-gnbitem 클릭 이벤트

        $block.find(".header-gnbitem").each(function() {

          const $this = $(this);

          const $thisLink = $this.find(".header-gnblink");

          const $sublist = $this.find(".header-sublist");

          if ($sublist.length) {

            $thisLink.off("click").on("click", function(event) {

              event.preventDefault();

              const $clickedItem = $(this).parents(".header-gnbitem");

              if (!$clickedItem.hasClass("item-active")) {

                $block.find(".header-gnbitem").removeClass("item-active");

                $block.find(".header-sublist").stop().slideUp(300);

              }

              $clickedItem.toggleClass("item-active");

              $sublist.stop().slideToggle(300);

            });

          }

        });

        isMobileMenuInitialized = true;

      }

      // 데스크탑 메뉴 초기화

      function initDesktopMenu() {

        if (isDesktopMenuInitialized) return;

        $block.find(".header-gnbitem").each(function() {

          const $this = $(this);

          const $thisLink = $this.find(".header-gnblink");

          $thisLink.off("click");

        });

        isDesktopMenuInitialized = true;

      }

      // 해상도에 따른 메뉴 처리

      function handleResize() {

        if (window.innerWidth <= 992) {

          if (!isMobileMenuInitialized) {

            initMobileMenu();

          }

          isDesktopMenuInitialized = false;

        } else {

          if (!isDesktopMenuInitialized) {

            initDesktopMenu();

          }

          isMobileMenuInitialized = false;

        }

      }

      // 스크롤 시 메뉴 처리

      function handleScroll() {

        const $headerTop = $block.find(".header-top");

        if ($headerTop.length) {

          $block.addClass("top-menu-active");

        }

        if ($(window).scrollTop() === 0) {

          $block.addClass("header-top-active");

        }

        $(window).scroll(function() {

          if ($(window).scrollTop() > 0) {

            $block.removeClass("header-top-active");

          } else {

            $block.addClass("header-top-active");

          }

        });

      }

      handleScroll();

      // 전체 메뉴 열기/닫기 처리

      function handleFullMenu() {

        $block.find(".btn-allmenu").on("click", function() {

          $block.find(".header-fullmenu").addClass("fullmenu-active");

        });

        $block.find(".fullmenu-close").on("click", function() {

          $block.find(".header-fullmenu").removeClass("fullmenu-active");

        });

        $block.find(".fullmenu-gnbitem").each(function() {

          const $this = $(this);

          $this.on("mouseover", function() {

            if (window.innerWidth > 992) {

              $this.find(".fullmenu-gnblink").addClass("on");

            }

          });

          $this.on("mouseout", function() {

            if (window.innerWidth > 992) {

              $this.find(".fullmenu-gnblink").removeClass("on");

            }

          });

        });

      }

      handleFullMenu();

      // 리사이즈 시마다 메뉴 동작 초기화

      $(window).on("resize", function() {

        handleResize();

      });

      handleResize();

    });

  });

})();
/* basic-N5 */
(function() {

  $(function() {

    $(".basic-N5[id=\'VnMdO3e6F3\']").each(function() {

      const $block = $(this);

      // Swiper

      const swiper = new Swiper(".basic-N5[id=\'VnMdO3e6F3\'] .contents-swiper", {

        slidesPerView: 1,

        spaceBetween: 0,

        loop: true,

        autoplay: {

          delay: 5000,

        },

        pagination: {

          el: ".basic-N5[id=\'VnMdO3e6F3\'] .swiper-pagination",

          type: "fraction",

          clickable: true,

          renderFraction: function(currentClass, totalClass) {

            return '<span class="' + currentClass + '"></span>' + '<span class="contents-deco"></span>' + '<span class="' + totalClass + '"></span>';

          }

        },

        navigation: {

          nextEl: ".basic-N5[id=\'VnMdO3e6F3\'] .swiper-button-next",

          prevEl: ".basic-N5[id=\'VnMdO3e6F3\'] .swiper-button-prev",

        },

      });

      // Swiper Play, Pause Button

      const pauseButton = $block.find('.swiper-button-pause');

      const playButton = $block.find('.swiper-button-play');

      playButton.hide();

      pauseButton.show();

      pauseButton.on('click', function() {

        swiper.autoplay.stop();

        playButton.show();

        pauseButton.hide();

      });

      playButton.on('click', function() {

        swiper.autoplay.start();

        playButton.hide();

        pauseButton.show();

      });

    });

  });

})();
/* basic-N9 */
(function() {

  $(function() {

    $(".basic-N9[id=\'wwmDO3E6Tl\']").each(function() {

      const $block = $(this);

      // Swiper

      const swiper = new Swiper(".basic-N9[id=\'wwmDO3E6Tl\'] .contents-swiper", {

        slidesPerView: 'auto',

        spaceBetween: 0,

        loop: true,

        navigation: {

          nextEl: ".basic-N9[id=\'wwmDO3E6Tl\'] .swiper-button-next",

          prevEl: ".basic-N9[id=\'wwmDO3E6Tl\'] .swiper-button-prev",

        },

      });

    });

  });

})();
