<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="' . $member_skin_url . '/style.css">', 0);
?>

<main>
  <!-- 회원가입약관 동의 시작 { -->
  <div class="wrapper">
    <div class="contents-container container-md">
      <div class="register">
        <form name="fregister" id="fregister" action="<?php echo $register_action_url ?>" onsubmit="return fregister_submit(this);" method="POST" autocomplete="off">
          <?php
          // 소셜로그인 사용시 소셜로그인 버튼
          @include_once(get_social_skin_path() . '/social_register.skin.php');
          ?>
          <section class="sc-register">
            <h2>회원가입 약관 동의</h2>
            <div class="form-box">
              <div class="checkset checkset-fill">
                <input id="chk_all" name="chk_all" class="checkset-input" type="checkbox">
                <label for="chk_all" class="checkset-label">약관 전체 동의</label>
              </div>
            </div>
            <div class="form-box">
              <div class="checkset checkset-fill">
                <input type="checkbox" name="agree" value="1" id="agree11" class="checkset-input">
                <label for="agree11" class="checkset-label">회원가입 약관</label>
              </div>
              <div class="info-box">
                <p><?php echo get_text($config['cf_stipulation']) ?></p>
              </div>
            </div>
            <div class="form-box">
              <div class="checkset checkset-fill">
                <input type="checkbox" name="agree2" value="1" id="agree21" class="checkset-input">
                <label for="agree21" class="checkset-label">개인정보 수집 및 이용</label>
              </div>
              <div class="info-box">
                <div class="info-item">
                  <strong>1. 수집목적</strong>
                  <ul>
                    <li>이용자 식별 및 본인 확인</li>
                    <li>고객서비스 이용에 관한 통지, CS대응을 이용자 식별</li>
                  </ul>
                </div>
                <div class="info-item">
                  <strong>2. 항목</strong>
                  <ul>
                    <li>이용자 식별 및 본인 확인</li>
                    <li>아이디, 이름, 비밀번호<?php echo ($config['cf_cert_use']) ? ", 생년월일, 휴대폰 번호(본인인증 할 때만, 아이핀 제외), 암호화된 개인식별부호(CI)" : ""; ?></li>
                  </ul>
                </div>
                <div class="info-item">
                  <strong>3. 보유기간</strong>
                  <ul>
                    <li>회원 탈퇴 시까지</li>
                  </ul>
                </div>
              </div>

            </div>
            <div class="btn-wrap">
              <a href="<?php echo G5_URL ?>" class="btnset btnset-line-dark btnset-lg">취소</a>
              <button type="submit" class="btnset btnset-dark btnset-lg">다음</button>
            </div>
          </section>
        </form>
        <script>
          function fregister_submit(f) {
            if (!f.agree.checked) {
              alert("회원가입약관의 내용에 동의하셔야 회원가입 하실 수 있습니다.");
              f.agree.focus();
              return false;
            }
            if (!f.agree2.checked) {
              alert("개인정보 수집 및 이용의 내용에 동의하셔야 회원가입 하실 수 있습니다.");
              f.agree2.focus();
              return false;
            }
            return true;
          }
          jQuery(function($) {
            // 모두선택
            $("input[name=chk_all]").click(function() {
              if ($(this).prop('checked')) {
                $("input[name^=agree]").prop('checked', true);
              } else {
                $("input[name^=agree]").prop("checked", false);
              }
            });
          });
        </script>
      </div>
    </div>
  </div>
  <!-- } 회원가입 약관 동의 끝 -->
</main>