<?php
if (!defined('_GNUBOARD_'))
  exit; // 개별 페이지 접근 불가
include_once(G5_LIB_PATH . '/thumbnail.lib.php');

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="' . $latest_skin_url . '/style.css">', 0);
$thumb_width = 240;
$thumb_height = 170;
$list_count = (is_array($list) && $list) ? count($list) : 0;
?>

<?php if ($list_count > 0) { ?>
  <div class="row row-cols-3 row-md-cols-1 gutter-5">
    <?php for ($i = 0; $i < $list_count; $i++) {
      $thumb = get_list_thumbnail($bo_table, $list[$i]['wr_id'], $thumb_width, $thumb_height, false, true);

      if ($thumb['src']) {
        $img = $thumb['src'];
      } else {
        $img = G5_IMG_URL . '/no_img.png';
        $thumb['alt'] = '이미지가 없습니다.';
      }
      $img_content = '<img src="' . $img . '" alt="' . $thumb['alt'] . '" >';
      $wr_href = get_pretty_url($bo_table, $list[$i]['wr_id']);
      $date = strtotime($list[$i]['wr_datetime']);
    ?>
      <a href="<?php echo $wr_href; ?>" class="col">
        <div class="cardset-round cardset cardset-hover cardset-border">
          <div class="cardset-cont">
            <h2 class="h5 cardset-tit"><?php echo $list[$i]['subject']; ?></h2>
            <p class="p1 cardset-desc">
              <?php 
              // content 필드가 있으면 사용, 없으면 subject 사용
              if (isset($list[$i]['wr_content']) && !empty($list[$i]['wr_content'])) {
                echo cut_str(strip_tags($list[$i]['wr_content']), 140);
              } else {
                echo cut_str($list[$i]['subject'], 50);
              }
              ?>  
            </p>
            <span class="p1 cardset-txt"><?php echo date('Y. m. d', $date); ?></span>
          </div>
        </div>
      </a>
    <?php } ?>
  </div>
<?php } else { //게시물이 없을 때  
?>
  <div class="tab-item">게시물이 없습니다.</div>
<?php } ?>