<?php
if (!defined('_INDEX_')) define('_INDEX_', true);
if (!defined('_GNUBOARD_')) exit; // 페이지 직접 접근 불가

// 모바일, 커뮤니티 분기
if (G5_IS_MOBILE) {
    include_once(G5_THEME_MOBILE_PATH . '/index.php');
    return;
}
if (G5_COMMUNITY_USE === false) {
    include_once(G5_THEME_SHOP_PATH . '/index.php');
    return;
}

// 헤더
include_once(G5_THEME_PATH . '/head.php');

// main.html 로드
$file_path_main = G5_THEME_PATH . '/temha/index.html';
if (!file_exists($file_path_main)) {
    die("파일을 찾을 수 없습니다: " . $file_path_main);
}
$html = file_get_contents($file_path_main);

// <main> 태그만 추출
preg_match('/(<main class="th-layout-main">.*?<\/main>)/s', $html, $block);
$content = isset($block[1]) ? $block[1] : "내용을 찾을 수 없습니다.";

// <article class="board_blank">...</article> 태그 삭제
$content = preg_replace('/<article class="board_blank">.*?<\/article>/s', '', $content);
?>

<?php
// 이 함수가 바로 최신글을 추출하는 역할을 합니다.
// 사용방법 : latest(스킨, 게시판아이디, 출력라인, 글자수);
// 테마의 스킨을 사용하려면 theme/temha_swiper 과 같이 지정  
ob_start(); 
echo latest('theme/temha_basic', 'notice', 16, 23);
$latest_html = ob_get_clean();
?>

<?php
//최신글을 주석에 치환
$content = str_replace('<!--board-latest-->',  $latest_html, $content);
// 출력
echo $content;
// 푸터
include_once(G5_THEME_PATH.'/tail.php');
?>
