<?php
if (!defined('_GNUBOARD_')) exit;
if (defined('G5_IS_ADMIN')) return;

if (G5_IS_MOBILE) {
  include_once(G5_THEME_MOBILE_PATH . '/head.php');
  return;
}

if (G5_COMMUNITY_USE === false) {
  define('G5_IS_COMMUNITY_PAGE', true);
  include_once(G5_THEME_SHOP_PATH . '/shop.head.php');
  return;
}

include_once(G5_THEME_PATH . '/head.sub.php');
include_once(G5_LIB_PATH . '/latest.lib.php');
include_once(G5_LIB_PATH . '/outlogin.lib.php');
include_once(G5_LIB_PATH . '/poll.lib.php');
include_once(G5_LIB_PATH . '/visit.lib.php');
include_once(G5_LIB_PATH . '/connect.lib.php');
include_once(G5_LIB_PATH . '/popular.lib.php');

// 기본 HTML 파일 로드 (index.html)
$file_path_main = G5_THEME_PATH . '/temha/index.html';
if (!file_exists($file_path_main)) {
  die("파일을 찾을 수 없습니다: " . $file_path_main);
}
$html = file_get_contents($file_path_main);

preg_match('/(<header class="th-layout-header">.*?<\/header>)/s', $html, $header);
$header = isset($header[1]) ? $header[1] : "헤더를 찾을 수 없습니다.";

ob_start();
echo outlogin("theme/temha_basic");
$login_html = ob_get_clean();
$header = str_replace('<!-- login -->', $login_html, $header);

if (defined('_INDEX_')) {
  include G5_BBS_PATH . '/newwin.inc.php';
}
// 관리자 및 페이지 설정 메뉴
include_once(G5_THEME_PATH.'/skin/pages/basic/quick_admin_menu.php')
?>


<?php echo $header;
// 비주얼 섹션 노출 조건: 게시판 페이지에서만 노출
// ===========================================
// 게시판 비주얼 처리 방법 (2가지 방식)
// ===========================================

// 방법 1: 템플릿하우스 에디터의 비주얼 블록을 파싱하여 노출하는 방법

// 구현 과정:
// 1. 템플릿하우스에서 별도 페이지 생성 (예: board_visual.html)
// 2. 비주얼 블록을 해당 페이지에 배치
// 3. 내보내기 후 그누보드에서 HTML 파일 파싱
// 4. 태그를 추적하여 정확한 블록 추출
// 5. 추출된 HTML을 게시판 상단에 출력

if (isset($bo_table) && !empty($bo_table)) {
  $sub_path = G5_THEME_PATH . '/temha/board.html';
  $sub_html = file_get_contents($sub_path);
  // 시작 태그 위치 찾기
  $start_pattern = '/<div class="basic-N45" id="JwMFqLuZM5">/';
  if (preg_match($start_pattern, $sub_html, $start_match, PREG_OFFSET_CAPTURE)) {
    $start_pos = $start_match[0][1];
    $remaining_html = substr($sub_html, $start_pos);

    $depth = 0;
    $pos = 0;
    $length = strlen($remaining_html);
    $in_tag = false;
    $tag_name = '';

    while ($pos < $length) {
      $char = $remaining_html[$pos];

      if ($char === '<') {
        $in_tag = true;
        $tag_name = '';
      } elseif ($char === '>' && $in_tag) {
        $in_tag = false;
        // 블록 레벨 태그들 확인 (시작 태그)
        if (preg_match('/^(div|section|article|main|aside|nav|header|footer)\b/i', trim($tag_name))) {
          $depth++;
        }
        // 블록 레벨 태그들 확인 (종료 태그)
        elseif (preg_match('/^\/(div|section|article|main|aside|nav|header|footer)\b/i', trim($tag_name))) {
          $depth--;
          if ($depth === 0) {
            $pos++; // > 다음 위치로 이동
            break;
          }
        }
        $tag_name = '';
      } elseif ($in_tag) {
        $tag_name .= $char;
      }
      $pos++;
    }
    // 추출된 HTML 출력
    $extracted_html = substr($remaining_html, 0, $pos);
    echo '<main class="th-layout-main">';
    echo '<div class="th-layout-content">';
    echo $extracted_html;
    echo '</div>';
    echo '</main>';
  }
}
 ?> 

</div>