<?php



/**

 * Temha Page Skin 자동 생성기

 */



// 기본 에러 설정

error_reporting(0);

ini_set('display_errors', 0);



// UTF-8 인코딩 설정

header('Content-Type: text/html; charset=UTF-8');

mb_internal_encoding('UTF-8');



// 경로 설정

$current_dir = dirname(__FILE__);



// 그누보드 기본 설정 로드

if (!defined('G5_SET_TIME_LIMIT')) {

  include_once($current_dir . '/common.php');

}



$theme_name = '';



// 그누보드 테마 설정 확인

if (defined('G5_THEME') && constant('G5_THEME')) {

  $theme_name = constant('G5_THEME');

} else {

  // 테마 폴더에서 temha 폴더가 있는 테마 찾기

  $theme_dir = $current_dir . '/theme/';

  if (is_dir($theme_dir)) {

    $dirs = @scandir($theme_dir);

    if ($dirs) {

      foreach ($dirs as $dir) {

        if ($dir != '.' && $dir != '..' && is_dir($theme_dir . $dir)) {

          if (is_dir($theme_dir . $dir . '/temha/')) {

            $theme_name = $dir;

            break;

          }

        }

      }

    }

  }

}

$temha_path = $current_dir . '/theme/' . $theme_name . '/temha/';

$skin_path = $current_dir . '/theme/' . $theme_name . '/skin/pages/basic/';

$log_file = $current_dir . '/auto_generate.log';



function writeLog($message)

{

  global $log_file;

  $timestamp = date('Y-m-d H:i:s');

  $log_message = "[$timestamp] $message\n";

  @file_put_contents($log_file, $log_message, FILE_APPEND | LOCK_EX);

}

function generateSkinFiles()

{

  global $temha_path, $skin_path;



  $success_count = 0;

  $total_count = 0;

  $generated_files = array();



  if (!is_dir($temha_path)) {

    return array('success' => 0, 'total' => 0, 'message' => 'temha 폴더를 찾을 수 없습니다.');

  }



  // skin 폴더가 없으면 생성

  if (!is_dir($skin_path)) {

    if (!@mkdir($skin_path, 0755, true)) {

      return array('success' => 0, 'total' => 0, 'message' => 'skin 폴더 생성에 실패했습니다.');

    }

    writeLog("✅ skin 폴더가 생성되었습니다: $skin_path");

  }

  

  // HTML 파일 목록 가져오기

  $html_files = array();

  if (is_dir($temha_path)) {

    $files = @scandir($temha_path);

    if ($files) {

      foreach ($files as $file) {

        if ($file != '.' && $file != '..' && $file != 'index.html') {

          $file_path = $temha_path . $file;

          if (is_file($file_path) && pathinfo($file, PATHINFO_EXTENSION) == 'html') {

            $html_files[] = pathinfo($file, PATHINFO_FILENAME);

          }

        }

      }

    }

  }



  $total_count = count($html_files);



  // 각 HTML 파일에 대해 .skin.php 파일 생성

  foreach ($html_files as $html_file) {

    $skin_filename = $html_file . '.skin.php';

    $skin_file_path = $skin_path . $skin_filename;



    // 이미 파일이 존재하면 건너뛰기

    if (file_exists($skin_file_path)) {

      $success_count++;

      $generated_files[] = array(

        'name' => $html_file,

        'id' => $html_file

      );

      continue;

    }

    $skin_content = '<?php

if (!defined("_GNUBOARD_"))

  exit; // 개별 페이지 접근 불가



// HTML 파일 경로 설정

$file_path_main = G5_THEME_PATH.\'/temha/' . $html_file . '.html\';



// 파일 존재 확인

if (!file_exists($file_path_main)) {

    return;

}



$html = file_get_contents($file_path_main);



// 가져오려는 HTML 부분이 특정 태그 안에 있다면 정규식을 활용

preg_match(\'/(<main class="th-layout-main">.*?<\/main>)/s\', $html, $block);



// 가져온 HTML 출력

$content = isset($block[1]) ? $block[1] : "내용을 찾을 수 없습니다.";



?>



<?php echo $content; //메인 섹션 ?>

';



    // 파일 생성

    if (@file_put_contents($skin_file_path, $skin_content)) {

      writeLog("✅ 성공적으로 생성되었습니다: $skin_filename");

      $success_count++;

      $generated_files[] = array(

        'name' => $html_file,

        'id' => $html_file

      );

    } else {

      writeLog("❌ 생성에 실패했습니다: $skin_filename");

    }

  }



  return array('success' => $success_count, 'total' => $total_count, 'message' => '', 'files' => $generated_files);

}



function deleteSelectedFiles($selected_files)

{

  global $temha_path, $skin_path;



  $deleted_count = 0;

  $deleted_files = array();

  $errors = array();



  // 선택된 파일들 삭제

  foreach ($selected_files as $html_file) {

    $html_file_path = $temha_path . $html_file . '.html';

    $skin_file = $html_file . '.skin.php';

    $skin_file_path = $skin_path . $skin_file;



    $file_deleted = false;



    // HTML 파일 삭제

    if (file_exists($html_file_path)) {

      if (@unlink($html_file_path)) {

        writeLog("🗑️ HTML 파일 삭제됨: $html_file.html");

        $file_deleted = true;

      } else {

        $errors[] = "HTML 파일 삭제 실패: $html_file.html";

      }

    }



    // 관련 skin.php 파일 삭제

    if (file_exists($skin_file_path)) {

      if (@unlink($skin_file_path)) {

        writeLog("🗑️ skin 파일 삭제됨: $skin_file");

        $file_deleted = true;

      } else {

        $errors[] = "skin 파일 삭제 실패: $skin_file";

      }

    }



    if ($file_deleted) {

      $deleted_count++;

      $deleted_files[] = array(

        'name' => $html_file,

        'id' => $html_file

      );

    }

  }



  $message = '';

  if (!empty($errors)) {

    $message = '일부 파일 삭제에 실패했습니다: ' . implode(', ', $errors);

  }



  return array('success' => $deleted_count, 'total' => count($selected_files), 'message' => $message, 'files' => $deleted_files);

}



function deleteOrphanSkinFiles()

{

  global $temha_path, $skin_path;



  $deleted_count = 0;

  $deleted_files = array();



  if (!is_dir($skin_path)) {

    return array('success' => 0, 'total' => 0, 'message' => 'skin 폴더를 찾을 수 없습니다.');

  }

  $skin_files = array();

  if (is_dir($skin_path)) {

    $files = @scandir($skin_path);

    if ($files) {

      foreach ($files as $file) {

        if ($file != '.' && $file != '..' && pathinfo($file, PATHINFO_EXTENSION) == 'php') {

          $filename = pathinfo($file, PATHINFO_FILENAME);

          if (strpos($filename, '.skin') !== false) {

            $html_filename = str_replace('.skin', '', $filename);

            $html_file_path = $temha_path . $html_filename . '.html';



            if (!file_exists($html_file_path)) {

              $skin_file_path = $skin_path . $file;

              if (@unlink($skin_file_path)) {

                writeLog("🗑️ 삭제되었습니다: $file (HTML 파일 없음)");

                $deleted_count++;

                $deleted_files[] = array(

                  'name' => $html_filename,

                  'id' => $html_filename

                );

              } else {

                writeLog("❌ 삭제 실패: $file");

              }

            }

          }

        }

      }

    }

  }



  return array('success' => $deleted_count, 'total' => $deleted_count, 'message' => '', 'files' => $deleted_files);

}



// AJAX 요청 처리

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action'])) {

  if ($_POST['action'] == 'generate') {

    $result = generateSkinFiles();

    echo json_encode($result);

    exit;

  } elseif ($_POST['action'] == 'delete_orphans') {

    $result = deleteOrphanSkinFiles();

    echo json_encode($result);

    exit;

  } elseif ($_POST['action'] == 'delete_selected') {

    $selected_files = isset($_POST['files']) ? $_POST['files'] : array();

    if (empty($selected_files)) {

      echo json_encode(array('success' => 0, 'total' => 0, 'message' => '삭제할 파일이 선택되지 않았습니다.'));

      exit;

    }

    $result = deleteSelectedFiles($selected_files);

    echo json_encode($result);

    exit;

  } elseif ($_POST['action'] == 'get_file_list') {

    // 파일 목록을 AJAX로 가져오기

    $html_files = array();

    $orphan_skin_files = array();

    

    // HTML 파일 목록 가져오기

    if (is_dir($temha_path)) {

      $files = @scandir($temha_path);

      if ($files) {

        foreach ($files as $file) {

          if ($file != '.' && $file != '..' && $file != 'index.html') {

            $file_path = $temha_path . $file;

            if (is_file($file_path) && pathinfo($file, PATHINFO_EXTENSION) == 'html') {

              $html_files[] = pathinfo($file, PATHINFO_FILENAME);

            }

          }

        }

      }

    }

    

    // 고아 skin 파일 찾기

    if (is_dir($skin_path)) {

      $files = @scandir($skin_path);

      if ($files) {

        foreach ($files as $file) {

          if ($file != '.' && $file != '..' && pathinfo($file, PATHINFO_EXTENSION) == 'php') {

            $filename = pathinfo($file, PATHINFO_FILENAME);

            if (strpos($filename, '.skin') !== false) {

              $html_filename = str_replace('.skin', '', $filename);

              $html_file_path = $temha_path . $html_filename . '.html';

              

              if (!file_exists($html_file_path)) {

                $orphan_skin_files[] = array(

                  'filename' => $file,

                  'name' => $html_filename,

                  'id' => $html_filename

                );

              }

            }

          }

        }

      }

    }

    

    // 기존 skin 파일 목록도 가져오기

    $existing_skin_files = array();

    if (is_dir($skin_path)) {

      $files = @scandir($skin_path);

      if ($files) {

        foreach ($files as $file) {

          if ($file != '.' && $file != '..' && pathinfo($file, PATHINFO_EXTENSION) == 'php') {

            $filename = pathinfo($file, PATHINFO_FILENAME);

            if (strpos($filename, '.skin') !== false) {

              $page_id = str_replace('.skin', '', $filename);

              $existing_skin_files[] = $page_id;

            }

          }

        }

      }

    }

    

    echo json_encode(array(

      'html_files' => $html_files,

      'orphan_skin_files' => $orphan_skin_files,

      'existing_skin_files' => $existing_skin_files

    ));

    exit;

  }

}



// 현재 상태 확인

$html_files = array();

$orphan_skin_files = array();



// HTML 파일 목록 가져오기

if (is_dir($temha_path)) {

  $files = @scandir($temha_path);

  if ($files) {

    foreach ($files as $file) {

      if ($file != '.' && $file != '..' && $file != 'index.html') {

        $file_path = $temha_path . $file;

        if (is_file($file_path) && pathinfo($file, PATHINFO_EXTENSION) == 'html') {

          $html_files[] = pathinfo($file, PATHINFO_FILENAME);

        }

      }

    }

  }

}



// 고아 skin 파일 찾기 (HTML 파일이 없는데 skin.php만 있는 경우)

if (is_dir($skin_path)) {

  $files = @scandir($skin_path);

  if ($files) {

    foreach ($files as $file) {

      if ($file != '.' && $file != '..' && pathinfo($file, PATHINFO_EXTENSION) == 'php') {

        $filename = pathinfo($file, PATHINFO_FILENAME);

        if (strpos($filename, '.skin') !== false) {

          $html_filename = str_replace('.skin', '', $filename);

          $html_file_path = $temha_path . $html_filename . '.html';



          if (!file_exists($html_file_path)) {

            $orphan_skin_files[] = array(

              'filename' => $file,

              'name' => $html_filename,

              'id' => $html_filename

            );

          }

        }

      }

    }

  }

}

?>



<!DOCTYPE html>

<html lang="ko">



<head>

  <meta charset="UTF-8">

  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <title>Temha Page Skin 자동 생성기</title>

  <style>

    body {

      font-family: Arial, sans-serif;

      margin: 20px;

      background-color: #f5f5f5;

    }



    .container {

      max-width: 800px;

      margin: 0 auto;

      background: white;

      padding: 20px;

      border-radius: 8px;

      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);

    }



    h1 {

      color: #333;

      border-bottom: 2px solid #007cba;

      padding-bottom: 10px;

    }



    .btn {

      background: #007cba;

      color: white;

      padding: 10px 20px;

      border: none;

      border-radius: 5px;

      cursor: pointer;

      font-size: 16px;

      margin: 10px 5px;

    }



    .btn:hover {

      background: #005a87;

    }



    .btn:disabled {

      background: #ccc;

      cursor: not-allowed;

    }



    .result-box {

      background: #f0f8f0;

      border: 1px solid #90ee90;

      padding: 15px;

      border-radius: 5px;

      margin: 20px 0;

    }



    .error-box {

      background: #ffe7e7;

      border: 1px solid #ffb3b3;

      padding: 15px;

      border-radius: 5px;

      margin: 20px 0;

    }



    table {

      width: 100%;

      border-collapse: collapse;

      margin: 20px 0;

    }



    th,

    td {

      border: 1px solid #ddd;

      padding: 12px;

      text-align: left;

    }



    th {

      background-color: #f2f2f2;

    }



    .status-exists {

      color: green;

      font-weight: bold;

    }



    .status-missing {

      color: red;

      font-weight: bold;

    }



    .loading {

      display: none;

      text-align: center;

      padding: 20px;

    }



    .url-list {

      background: #f8f9fa;

      border: 1px solid #e9ecef;

      border-radius: 8px;

      padding: 15px;

      margin: 15px 0;

    }



    .url-list h4 {

      margin: 0 0 10px 0;

      color: #495057;

      font-size: 14px;

    }



    .url-item {

      display: flex;

      align-items: center;

      padding: 8px 12px;

      margin: 5px 0;

      background: white;

      border: 1px solid #dee2e6;

      border-radius: 6px;

      transition: all 0.2s ease;

    }



    .url-item:hover {

      background: #e3f2fd;

      border-color: #2196f3;

      transform: translateX(5px);

    }



    .url-label {

      font-weight: bold;

      color: #495057;

      min-width: 60px;

      margin-right: 10px;

    }



    .url-link {

      color: #007cba;

      text-decoration: none;

      font-family: 'Courier New', monospace;

      font-size: 13px;

      flex: 1;

    }



    .url-link:hover {

      color: #005a87;

      text-decoration: underline;

    }



    .copy-btn {

      background: #28a745;

      color: white;

      border: none;

      padding: 4px 8px;

      border-radius: 4px;

      font-size: 11px;

      cursor: pointer;

      margin-left: 10px;

      transition: background 0.2s ease;

    }



    .copy-btn:hover {

      background: #218838;

    }

  </style>

</head>



<body>

  <div class="container">

    <h1>🚀 Temha Page Skin 자동 생성기</h1>



    <div class="result-box" id="resultBox" style="display: none;">

      <h3>✅ 생성 결과</h3>

      <p id="resultMessage"></p>

    </div>



    <div class="error-box" id="errorBox" style="display: none;">

      <h3>❌ 오류</h3>

      <p id="errorMessage"></p>

    </div>



    <div class="loading" id="loading">

      <p>처리 중...</p>

    </div>



    <h3>📁 현재 HTML 파일 상태</h3>

    <table>

      <thead>

        <tr>

          <th><input type="checkbox" id="selectAll" onchange="toggleAllCheckboxes(this)"> 전체선택</th>

          <th>HTML 파일</th>

          <th>생성될 .skin.php 파일</th>

          <th>상태</th>

        </tr>

      </thead>

      <tbody>

        <?php if (empty($html_files)): ?>

          <tr>

            <td colspan="4" style="text-align: center; color: #666;">HTML 파일이 없습니다.</td>

          </tr>

        <?php else: ?>

          <?php foreach ($html_files as $html_file): ?>

            <?php

            $skin_file = $html_file . '.skin.php';

            $skin_file_path = $skin_path . $skin_file;

            $exists = file_exists($skin_file_path);

            ?>

            <tr>

              <td><input type="checkbox" class="file-checkbox" value="<?php echo $html_file; ?>"></td>

              <td><?php echo $html_file; ?>.html</td>

              <td><?php echo $skin_file; ?></td>

              <td>

                <?php if ($exists): ?>

                  <span class="status-exists">✅ 이미 생성됨</span>

                <?php else: ?>

                  <span class="status-missing">❌ 미생성</span>

                <?php endif; ?>

              </td>

            </tr>

          <?php endforeach; ?>

        <?php endif; ?>

      </tbody>

    </table>



    <?php if (!empty($orphan_skin_files)): ?>

      <h3>⚠️ 삭제 가능한 고아 파일</h3>

      <div class="error-box">

        <p>다음 파일들은 HTML 파일이 없는데 skin.php 파일만 존재합니다. 삭제하시겠습니까?</p>

        <ul>

          <?php foreach ($orphan_skin_files as $orphan): ?>

            <li><strong><?php echo $orphan['name']; ?>.skin.php</strong> (<?php echo $orphan['name']; ?>.html 파일 없음)</li>

          <?php endforeach; ?>

        </ul>

      </div>

    <?php endif; ?>



    <div style="text-align: center;">

      <button id="generateBtn" class="btn">🚀 자동 생성 실행</button>

      <button id="deleteSelectedBtn" class="btn" style="background: #dc3545;" disabled>🗑️ 선택된 파일 삭제</button>

      <button id="refreshBtn" class="btn">🔄 새로고침</button>

    </div>



    <div class="url-list" id="urlList">

      <h4>📋 확인할 수 있는 URL:</h4>

      <div id="urlItems">

        <?php

        $existing_skin_files = array();

        if (is_dir($skin_path)) {

          $files = @scandir($skin_path);

          if ($files) {

            foreach ($files as $file) {

              if ($file != '.' && $file != '..' && pathinfo($file, PATHINFO_EXTENSION) == 'php') {

                $filename = pathinfo($file, PATHINFO_FILENAME);

                if (strpos($filename, '.skin') !== false) {

                  $page_id = str_replace('.skin', '', $filename);

                  $existing_skin_files[] = $page_id;

                }

              }

            }

          }

        }



        if (!empty($existing_skin_files)): ?>

          <?php foreach ($existing_skin_files as $page_id): ?>

            <div class="url-item">

              <span class="url-label"><?php echo $page_id; ?>:</span>

              <a href="/page.php?id=<?php echo $page_id; ?>" class="url-link" target="_blank">/page.php?id=<?php echo $page_id; ?></a>

              <button class="copy-btn" onclick="copyToClipboard('/page.php?id=<?php echo $page_id; ?>', event)">복사</button>

            </div>

          <?php endforeach; ?>

        <?php endif; ?>

      </div>

    </div>



    <div style="background: #e7f3ff; border: 1px solid #b3d9ff; padding: 15px; border-radius: 5px; margin: 20px 0;">

      <h3>💡 사용 방법</h3>

      <ol>

        <li>/theme/<?php echo $theme_name; ?>/skin/pages/basic 폴더의 권한을 777로 설정합니다</li>

        <li>/theme/<?php echo $theme_name; ?>/temha/ 폴더의 권한을 777로 설정합니다</li>

        <li>/theme/<?php echo $theme_name; ?>/temha/ 폴더에 HTML 파일을 추가합니다 (index.html은 서브페이지에서 제외합니다)</li>

        <li>위의 "자동 생성 실행" 버튼을 클릭합니다</li>

        <li>생성된 .skin.php 파일을 그누보드 페이지에서 사용할 수 있습니다</li>

      </ol>

    </div>

  </div>



  <script>

    // 파일 목록을 AJAX로 가져오는 함수

    async function getFileList() {

      try {

        const response = await fetch('', {

          method: 'POST',

          headers: {

            'Content-Type': 'application/x-www-form-urlencoded',

          },

          body: 'action=get_file_list'

        });

        return await response.json();

      } catch (error) {

        console.error('파일 목록 가져오기 실패:', error);

        return null;

      }

    }



    // 테이블을 동적으로 업데이트하는 함수

    function updateFileTable(htmlFiles, existingSkinFiles = []) {

      const tbody = document.querySelector('table tbody');

      tbody.innerHTML = '';



      if (htmlFiles.length === 0) {

        tbody.innerHTML = '<tr><td colspan="4" style="text-align: center; color: #666;">HTML 파일이 없습니다.</td></tr>';

        return;

      }



      htmlFiles.forEach(htmlFile => {

        const row = document.createElement('tr');

        const skinExists = existingSkinFiles.includes(htmlFile);

        const statusClass = skinExists ? 'status-exists' : 'status-missing';

        const statusText = skinExists ? '✅ 이미 생성됨' : '❌ 미생성';

        

        row.innerHTML = `

          <td><input type="checkbox" class="file-checkbox" value="${htmlFile}"></td>

          <td>${htmlFile}.html</td>

          <td>${htmlFile}.skin.php</td>

          <td><span class="${statusClass}">${statusText}</span></td>

        `;

        tbody.appendChild(row);

      });



      // 이벤트 리스너 재등록

      registerEventListeners();

    }



    // 고아 파일 섹션 업데이트

    function updateOrphanFiles(orphanFiles) {

      const deleteOrphansBtn = document.getElementById('deleteOrphansBtn');

      

      if (orphanFiles.length > 0) {

        // 고아 파일 섹션이 없으면 생성

        let orphanDiv = document.querySelector('#orphanFilesSection');

        if (!orphanDiv) {

          const tableSection = document.querySelector('table').parentElement;

          orphanDiv = document.createElement('div');

          orphanDiv.id = 'orphanFilesSection';

          orphanDiv.innerHTML = `

            <h3>⚠️ 삭제 가능한 스킨 파일</h3>

            <div class="error-box">

              <p>다음 파일들은 HTML 파일이 없는데 skin.php 파일만 존재합니다. 삭제하시겠습니까?</p>

              <ul id="orphanList"></ul>

            </div>

          `;

          tableSection.insertAdjacentElement('afterend', orphanDiv);

        }



        const orphanList = document.getElementById('orphanList');

        orphanList.innerHTML = '';

        orphanFiles.forEach(orphan => {

          const li = document.createElement('li');

          li.innerHTML = `<strong>${orphan.name}.skin.php</strong> (${orphan.name}.html 파일 없음)`;

          orphanList.appendChild(li);

        });

        

        // 고아 파일 삭제 버튼 활성화

        deleteOrphansBtn.disabled = false;

      } else {

        const orphanDiv = document.getElementById('orphanFilesSection');

        if (orphanDiv) {

          orphanDiv.remove();

        }

        

        // 고아 파일 삭제 버튼 비활성화

        deleteOrphansBtn.disabled = true;

      }

    }



    // URL 목록 업데이트

    function updateUrlList(existingSkinFiles) {

      const urlItems = document.getElementById('urlItems');

      console.log('URL 리스트 업데이트:', existingSkinFiles); // 디버깅용

      urlItems.innerHTML = '';



      if (existingSkinFiles.length > 0) {

        existingSkinFiles.forEach(pageId => {

          const urlItem = document.createElement('div');

          urlItem.className = 'url-item';

          urlItem.innerHTML = `

            <span class="url-label">${pageId}:</span>

            <a href="/page.php?id=${pageId}" class="url-link" target="_blank">/page.php?id=${pageId}</a>

            <button class="copy-btn" onclick="copyToClipboard('/page.php?id=${pageId}', event)">복사</button>

          `;

          urlItems.appendChild(urlItem);

        });

      } else {

        // URL이 없을 때 안내 메시지 표시

        urlItems.innerHTML = '<div style="text-align: center; color: #666; padding: 20px;">생성된 페이지가 없습니다.</div>';

      }

    }



    // 전체 파일 목록 새로고침

    async function refreshFileList() {

      try {

        const data = await getFileList();

        if (data) {

          console.log('새로고침 데이터:', data); // 디버깅용

          updateFileTable(data.html_files, data.existing_skin_files);

          updateOrphanFiles(data.orphan_skin_files);

          updateUrlList(data.existing_skin_files);

          updateSelectAllCheckbox();

          updateDeleteButton();

        }

      } catch (error) {

        console.error('파일 목록 새로고침 실패:', error);

      }

    }



    // 페이지 로드 시 초기 파일 목록 새로고침

    document.addEventListener('DOMContentLoaded', function() {

      registerEventListeners();

      refreshFileList(); // 초기 로드 시 파일 목록 새로고침

    });



    // 전체 선택/해제

    function toggleAllCheckboxes(selectAllCheckbox) {

      const checkboxes = document.querySelectorAll('.file-checkbox');

      checkboxes.forEach(checkbox => {

        checkbox.checked = selectAllCheckbox.checked;

      });

      updateDeleteButton();

    }



    // 전체 선택 체크박스 상태 업데이트

    function updateSelectAllCheckbox() {

      const checkboxes = document.querySelectorAll('.file-checkbox');

      const selectAllCheckbox = document.getElementById('selectAll');

      const checkedCount = document.querySelectorAll('.file-checkbox:checked').length;



      if (checkedCount === 0) {

        selectAllCheckbox.checked = false;

        selectAllCheckbox.indeterminate = false;

      } else if (checkedCount === checkboxes.length) {

        selectAllCheckbox.checked = true;

        selectAllCheckbox.indeterminate = false;

      } else {

        selectAllCheckbox.checked = false;

        selectAllCheckbox.indeterminate = true;

      }

    }



    // 삭제 버튼 상태 관리

    function updateDeleteButton() {

      const checkedCount = document.querySelectorAll('.file-checkbox:checked').length;

      const deleteBtn = document.getElementById('deleteSelectedBtn');

      deleteBtn.disabled = checkedCount === 0;

    }



    // 이벤트 리스너 등록 함수

    function registerEventListeners() {

      const checkboxes = document.querySelectorAll('.file-checkbox');

      checkboxes.forEach(checkbox => {

        checkbox.addEventListener('change', function() {

          updateSelectAllCheckbox();

          updateDeleteButton();

        });

      });

    }





    document.getElementById('generateBtn').addEventListener('click', function() {

      const loading = document.getElementById('loading');

      const resultBox = document.getElementById('resultBox');

      const errorBox = document.getElementById('errorBox');

      const generateBtn = document.getElementById('generateBtn');



      loading.style.display = 'block';

      resultBox.style.display = 'none';

      errorBox.style.display = 'none';

      generateBtn.disabled = true;



      fetch('', {

          method: 'POST',

          headers: {

            'Content-Type': 'application/x-www-form-urlencoded',

          },

          body: 'action=generate'

        })

        .then(response => response.json())

        .then(data => {

          loading.style.display = 'none';

          generateBtn.disabled = false;



          if (data.success !== undefined) {

            resultBox.style.display = 'block';

            let message = `총 ${data.total}개 파일 중 ${data.success}개 파일이 성공적으로 생성되었습니다.`;

            document.getElementById('resultMessage').innerHTML = message;



            // 생성된 파일들의 확인 URL을 별도 섹션에 표시

            if (data.files && data.files.length > 0) {

              const urlItems = document.getElementById('urlItems');



              data.files.forEach(function(file) {

                // 기존에 같은 ID의 URL이 있는지 확인

                const existingLink = urlItems.querySelector(`a[href="/page.php?id=${file.id}"]`);

                if (!existingLink) {

                  const urlItem = document.createElement('div');

                  urlItem.className = 'url-item';

                  urlItem.innerHTML = `

                    <span class="url-label">${file.name}:</span>

                    <a href="/page.php?id=${file.id}" class="url-link" target="_blank">/page.php?id=${file.id}</a>

                    <button class="copy-btn" onclick="copyToClipboard('/page.php?id=${file.id}', event)">복사</button>

                  `;

                  urlItems.appendChild(urlItem);

                }

              });

            }



            // 파일 목록 자동 새로고침

            setTimeout(() => {

              refreshFileList();

            }, 1000);

          } else {

            errorBox.style.display = 'block';

            document.getElementById('errorMessage').textContent = data.message || '알 수 없는 오류가 발생했습니다.';

          }

        })

        .catch(error => {

          loading.style.display = 'none';

          generateBtn.disabled = false;

          errorBox.style.display = 'block';

          document.getElementById('errorMessage').textContent = '네트워크 오류가 발생했습니다: ' + error;

        });

    });



    document.getElementById('refreshBtn').addEventListener('click', function() {

      refreshFileList();

    });



    // 선택된 파일 삭제 버튼 이벤트

    document.getElementById('deleteSelectedBtn').addEventListener('click', function() {

      const selectedFiles = Array.from(document.querySelectorAll('.file-checkbox:checked')).map(cb => cb.value);



      if (selectedFiles.length === 0) {

        alert('삭제할 파일을 선택해주세요.');

        return;

      }



      if (!confirm(`선택된 ${selectedFiles.length}개 파일을 삭제하시겠습니까?\n\n삭제될 파일:\n- ${selectedFiles.join('.html\n- ')}.html\n- ${selectedFiles.join('.skin.php\n- ')}.skin.php\n\n이 작업은 되돌릴 수 없습니다.`)) {

        return;

      }



      const loading = document.getElementById('loading');

      const resultBox = document.getElementById('resultBox');

      const errorBox = document.getElementById('errorBox');

      const deleteBtn = document.getElementById('deleteSelectedBtn');



      loading.style.display = 'block';

      resultBox.style.display = 'none';

      errorBox.style.display = 'none';

      deleteBtn.disabled = true;



      // 선택된 파일들을 FormData로 전송

      const formData = new FormData();

      formData.append('action', 'delete_selected');

      selectedFiles.forEach(file => {

        formData.append('files[]', file);

      });



      fetch('', {

          method: 'POST',

          body: formData

        })

        .then(response => response.json())

        .then(data => {

          loading.style.display = 'none';

          deleteBtn.disabled = false;



          if (data.success !== undefined) {

            resultBox.style.display = 'block';

            let message = `총 ${data.total}개 파일 중 ${data.success}개 파일이 삭제되었습니다.`;

            if (data.message) {

              message += '<br><br>' + data.message;

            }

            document.getElementById('resultMessage').innerHTML = message;



            // 파일 목록 새로고침 (약간의 지연 후)

            setTimeout(() => {

              refreshFileList();

            }, 500);

          } else {

            errorBox.style.display = 'block';

            document.getElementById('errorMessage').textContent = data.message || '알 수 없는 오류가 발생했습니다.';

          }

        })

        .catch(error => {

          loading.style.display = 'none';

          deleteBtn.disabled = false;

          errorBox.style.display = 'block';

          document.getElementById('errorMessage').textContent = '네트워크 오류가 발생했습니다: ' + error;

        });

    });



    // 고아 파일 삭제 버튼 이벤트

    document.getElementById('deleteOrphansBtn').addEventListener('click', function() {

      if (!confirm('정말로 고아 파일들을 삭제하시겠습니까? 이 작업은 되돌릴 수 없습니다.')) {

        return;

      }



      const loading = document.getElementById('loading');

      const resultBox = document.getElementById('resultBox');

      const errorBox = document.getElementById('errorBox');

      const deleteBtn = document.getElementById('deleteOrphansBtn');



      loading.style.display = 'block';

      resultBox.style.display = 'none';

      errorBox.style.display = 'none';

      deleteBtn.disabled = true;



      fetch('', {

          method: 'POST',

          headers: {

            'Content-Type': 'application/x-www-form-urlencoded',

          },

          body: 'action=delete_orphans'

        })

        .then(response => response.json())

        .then(data => {

          loading.style.display = 'none';

          deleteBtn.disabled = false;



          if (data.success !== undefined) {

            resultBox.style.display = 'block';

            let message = `총 ${data.success}개의 고아 파일이 삭제되었습니다.`;

            document.getElementById('resultMessage').innerHTML = message;



            // 파일 목록 새로고침 (약간의 지연 후)

            setTimeout(() => {

              refreshFileList();

            }, 500);

          } else {

            errorBox.style.display = 'block';

            document.getElementById('errorMessage').textContent = data.message || '알 수 없는 오류가 발생했습니다.';

          }

        })

        .catch(error => {

          loading.style.display = 'none';

          deleteBtn.disabled = false;

          errorBox.style.display = 'block';

          document.getElementById('errorMessage').textContent = '네트워크 오류가 발생했습니다: ' + error;

        });

    });



    // URL 복사 기능

    async function copyToClipboard(text, event) {

      const urlItem = event.target.closest('.url-item');

      const linkElement = urlItem ? urlItem.querySelector('.url-link') : null;

      const linkText = linkElement ? linkElement.textContent.trim() : text;



      try {

        if (navigator.clipboard && navigator.clipboard.writeText) {

          await navigator.clipboard.writeText(linkText);

          event.target.textContent = "복사되었습니다.";

          event.target.style.background = '#28a745';

          setTimeout(() => {

            event.target.textContent = '복사';

            event.target.style.background = '#28a745';

          }, 2000);

        } else {

          // Fallback 방식 (HTTPS 아닐 때)

          const textarea = document.createElement("textarea");

          textarea.value = linkText;

          textarea.style.position = "fixed";

          textarea.style.opacity = "0";

          document.body.appendChild(textarea);

          textarea.select();



          const success = document.execCommand("copy");

          document.body.removeChild(textarea);



          if (success) {

            event.target.textContent = "복사되었습니다.";

            event.target.style.background = '#28a745';

            setTimeout(() => {

              event.target.textContent = '복사';

              event.target.style.background = '#28a745';

            }, 2000);

          } else {

            throw new Error("execCommand 복사 실패");

          }

        }

      } catch (err) {

        console.error("복사 실패:", err);

        event.target.textContent = "복사 실패";

        event.target.style.background = '#dc3545';

        setTimeout(() => {

          event.target.textContent = '복사';

          event.target.style.background = '#28a745';

        }, 3000);

      }

    }

  </script>

</body>



</html>