<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가

// 필수 상수가 정의되어 있지 않다면 실행하지 않음
if (!defined('G5_THEME_URL') || !defined('G5_URL') || !defined('G5_TABLE_PREFIX')) {
  return;
}

define('G5_TEMHA_RESOUCES',      G5_THEME_URL . '/temha/resources');
//define('G5_PAGES_URL',			G5_URL.'/pages');
//$g5['appointment_table']    = G5_TABLE_PREFIX . 'appointment';

$pages_skin_path    = get_skin_path('pages', 'theme/basic');
$pages_skin_url      = get_skin_url('pages', 'theme/basic');



// 한페이지에 보여줄 행, 현재페이지, 총페이지수, URL
function get_paging_new($write_pages, $cur_page, $total_page, $url, $add = "")
{
  //$url = preg_replace('#&amp;page=[0-9]*(&amp;page=)$#', '$1', $url);
  $url = preg_replace('#(&amp;)?page=[0-9]*#', '', $url);
  $url .= substr($url, -1) === '?' ? 'page=' : '&amp;page=';
  $url = preg_replace('|[^\w\-~+_.?#=!&;,/:%@$\|*\'()\[\]\\x80-\\xff]|i', '', clean_xss_tags($url));

  $str = '';
  if ($cur_page > 1) {
    $str .= '<div class="pagiset-ctrl">' . PHP_EOL;
    $str .= '<a class="pagiset-link pagiset-first" href="' . $url . '1' . $add . '">' . PHP_EOL;
    $str .= '<span class="visually-hidden">처음</span>' . PHP_EOL;
    $str .= '</a>' . PHP_EOL;
    $str .= '</div>' . PHP_EOL;
  }

  $start_page = (((int)(($cur_page - 1) / $write_pages)) * $write_pages) + 1;
  $end_page = $start_page + $write_pages - 1;

  if ($end_page >= $total_page) $end_page = $total_page;

  if ($start_page > 1) {

    $str .= '<div class="pagiset-ctrl">' . PHP_EOL;
    $str .= '<a class="pagiset-link pagiset-prev" href="' . $url . ($start_page - 1) . $add . '">' . PHP_EOL;
    $str .= '<span class="visually-hidden">이전</span>' . PHP_EOL;
    $str .= '</a>' . PHP_EOL;
    $str .= '</div> ' . PHP_EOL;
  }

  if ($total_page > 1) {
    $str .= '<div class="pagiset-list">' . PHP_EOL;
    for ($k = $start_page; $k <= $end_page; $k++) {
      $str .= '<a class="pagiset-link' . ($cur_page == $k ? ' active-fill' : '') . '" href="' . $url . $k . $add . '">' . $k . '</a>' . PHP_EOL;
    }
    $str .= '</div>' . PHP_EOL;
  }

  if ($total_page > $end_page) {

    $str .= '<div class="pagiset-ctrl">' . PHP_EOL;
    $str .= '<a class="pagiset-link pagiset-next" href="' . $url . ($end_page + 1) . $add . '">' . PHP_EOL;
    $str .= '<span class="visually-hidden">다음</span>' . PHP_EOL;
    $str .= '</a>' . PHP_EOL;
    $str .= '</div>' . PHP_EOL;
  }

  if ($cur_page < $total_page) {
    $str .= '<div class="pagiset-ctrl">' . PHP_EOL;
    $str .= '<a class="pagiset-link pagiset-last" href="' . $url . $total_page . $add . '">' . PHP_EOL;
    $str .= '<span class="visually-hidden">마지막</span>' . PHP_EOL;
    $str .= '</a>' . PHP_EOL;
    $str .= '</div>' . PHP_EOL;
  }

  if ($str)
    return "<nav class=\"pagiset pagiset-circ\">{$str}</span></nav>";
  else
    return "";
}
